' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class AddEditContent
  Inherits System.Web.UI.Page

  Private contentId As Integer = -1

  Protected Sub Page_Load(ByVal sender As Object, _
      ByVal e As System.EventArgs) Handles Me.Load

    If Request.QueryString.Get("Id") IsNot Nothing Then
      contentId = Convert.ToInt32(Request.QueryString.Get("Id"))
    End If

    If Not Page.IsPostBack And contentId > 0 Then
      Dim myContentItem As Content = Content.GetItem(contentId)
      If myContentItem IsNot Nothing Then
        Me.Title = "Edycja: " & myContentItem.Title
        txtTitle.Text = myContentItem.Title
        txtIntroText.Value = myContentItem.IntroText
        txtBodyText.Value = myContentItem.BodyText
        chkVisible.Checked = myContentItem.Visible

        lstContentTypes.DataBind()
        lstContentTypes.SelectedValue = myContentItem.ContentTypeId.ToString()

        lstCategories.DataBind()
        lstCategories.SelectedValue = myContentItem.CategoryId.ToString()
      End If
    End If
  End Sub

  Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
    Page.Validate()
    If Page.IsValid Then
      Dim myContentItem As Content
      If Request.QueryString.Get("Id") IsNot String.Empty Then
        myContentItem = New Content(Convert.ToInt32(Request.QueryString.Get("Id")))
      Else
        myContentItem = New Content()
      End If
      myContentItem.Title = txtTitle.Text
      myContentItem.IntroText = txtIntroText.Value
      myContentItem.BodyText = txtBodyText.Value
      myContentItem.Visible = chkVisible.Checked
      myContentItem.ContentTypeId = Convert.ToInt32(lstContentTypes.SelectedValue)
      myContentItem.CategoryId = Convert.ToInt32(lstCategories.SelectedValue)
      myContentItem.Save()
      Response.Redirect("ContentList.aspx")
    End If
  End Sub

  Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
    Response.Redirect("ContentList.aspx")
  End Sub
End Class
